<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Listagem de Arquivos</title>
</head>
<body>

    <h2>Listagem de Arquivos</h2>

    <?php
    $caminho_pasta = '/media/fullrx';
    
    // Verifica se o caminho da pasta é válido
    if (is_dir($caminho_pasta)) {
        
        // Obtém a lista de arquivos na pasta com informações de data e hora
        $arquivos_info = [];
        $arquivos = scandir($caminho_pasta);
        
        // Remove os diretórios '.' e '..'
        $arquivos = array_diff($arquivos, array('.', '..'));
        
        foreach ($arquivos as $arquivo) {
            $caminho_arquivo = $caminho_pasta . '/' . $arquivo;
            $arquivos_info[$arquivo] = [
                'data_modificacao' => date("Y-m-d H:i:s", filemtime($caminho_arquivo)),
            ];
        }
        
        // Conta o número de arquivos
        $num_arquivos = count($arquivos);
        
        if ($num_arquivos > 5) {
            echo "<p>false_limite</p>";
        } else {
            echo "<p>Existem $num_arquivos arquivos na pasta $caminho_pasta.</p>";
        }
        
        // Caixa de pesquisa
        echo '<form action="" method="post">';
        echo '<label for="search">Procurar arquivos:</label>';
        echo '<input type="text" name="search" id="search">';
        echo '<input type="submit" value="Procurar">';
        echo '</form>';
        
        // Lógica de pesquisa e listagem de arquivos com data, hora e tempo desde a modificação do primeiro arquivo
        if ($_SERVER["REQUEST_METHOD"] == "POST") {
            $termo_pesquisa = $_POST['search'];
            
            echo '<h3>Resultados da pesquisa:</h3>';
            
            foreach ($arquivos_info as $arquivo => $info) {
                if ($termo_pesquisa === '' || stripos($arquivo, $termo_pesquisa) !== false) {
                    echo "<p>$arquivo - Última modificação: {$info['data_modificacao']} - ";
                    echo "Tempo desde a modificação: " . calcularTempoDesdeModificacao($info['data_modificacao']) . " minutos</p>";
                }
            }
        } else {
            // Se nenhum termo de pesquisa fornecido, listar todos os arquivos
            echo '<h3>Listagem de todos os arquivos:</h3>';
            
            // Armazenar o primeiro arquivo e o tempo desde a modificação em uma variável
            $primeiro_arquivo = reset($arquivos_info);
            $tempo_desde_modificacao = calcularTempoDesdeModificacao($primeiro_arquivo['data_modificacao']);

            echo "<p>1A = $tempo_desde_modificacao minutos</p>";

            foreach ($arquivos_info as $arquivo => $info) {
                echo "<p>$arquivo - Última modificação: {$info['data_modificacao']} - ";
                echo "Tempo desde a modificação: " . calcularTempoDesdeModificacao($info['data_modificacao']) . " minutos</p>";
            }
        }
        
    } else {
        echo "<p>O caminho da pasta não é válido.</p>";
    }

    function calcularTempoDesdeModificacao($data_modificacao) {
        $data_atual = new DateTime();
        $data_modificacao = new DateTime($data_modificacao);
        $intervalo = $data_atual->diff($data_modificacao);
        return $intervalo->days * 24 * 60 + $intervalo->h * 60 + $intervalo->i;
    }
    ?>

</body>
</html>