if(isset($_POST['generate_json'])) {
    $schedule_id = $_POST['schedule_id'];

    // Obter a programação e os assets associados
    $stmt = $pdo->prepare("
        SELECT a.filename, a.duration, a.is_video
        FROM schedule_assets sa
        JOIN assets a ON sa.asset_id = a.id
        WHERE sa.schedule_id = ?
    ");
    $stmt->execute([$schedule_id]);
    $assets = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $json = [
        "version" => 42,
        "layout" => "1",
        "settings" => [
            "ticker" => [
                "enable" => false,
                "behavior" => "scroll",
                "textSpeed" => 3,
                "rss" => [
                    "enable" => false,
                    "link" => null,
                    "feedDelay" => 10
                ]
            ],
            "ads" => [
                "adPlaylist" => false,
                "adCount" => 1,
                "adInterval" => 60
            ],
            "audio" => [
                "enable" => false,
                "random" => false,
                "volume" => 50
            ]
        ],
        "assets" => [],
        "templateName" => "custom_layout.html",
        "videoWindow" => null,
        "zoneVideoWindow" => [],
        "groupIds" => null
    ];

    // Adicionar assets ao JSON
    foreach($assets as $asset) {
        $json_asset = [
            "filename" => $asset['filename'],
            "duration" => $asset['duration'],
            "selected" => true,
            "option" => ["main" => false],
            "dragSelected" => false,
            "fullscreen" => true
        ];

        if($asset['is_video']) {
            $json_asset["isVideo"] = true;
        }

        $json['assets'][] = $json_asset;
    }

    // Salvar o JSON em um arquivo
    file_put_contents("schedule_{$schedule_id}.json", json_encode($json, JSON_PRETTY_PRINT));
}
